/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.DecimalRepBuf;
import cc.tweaked.internal.cobalt.lib.doubles.Ieee;
import cc.tweaked.internal.cobalt.lib.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.SignedPositive;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;

public class FixedDtoa {
    private static final @UnknownVal @Signed int DOUBLE_SIGNIFICAND_SIZE = 53;
    private static final @Unsigned @UnknownVal long TEN_POW_OF_7 = 10000000L;

    private static void fillDigits32FixedLength(@Unsigned @UnknownVal int number, @UnknownVal @Signed int requestedLength, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        int start = buf.length();
        buf.addLength(requestedLength);
        for (int i = buf.length() - 1; i >= start; --i) {
            buf.setCharAt(i, UnsignedValues.uRemainder(number, 10));
            number = UnsignedValues.uDivide(number, 10);
        }
    }

    private static void fillDigits32(@Unsigned @UnknownVal int number, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        int start = buf.length();
        while (number != 0) {
            @Unsigned int digit = UnsignedValues.uRemainder(number, 10);
            number = UnsignedValues.uDivide(number, 10);
            buf.append(digit);
        }
        buf.reverseLast(start);
    }

    private static void fillDigits64FixedLength(@Unsigned @UnknownVal long number, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        @Unsigned int part2 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        number = UnsignedValues.uDivide(number, 10000000L);
        @Unsigned int part1 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        @Unsigned int part0 = UnsignedValues.toUint(UnsignedValues.uDivide(number, 10000000L));
        FixedDtoa.fillDigits32FixedLength(part0, 3, buf);
        FixedDtoa.fillDigits32FixedLength(part1, 7, buf);
        FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
    }

    private static void fillDigits64(@Unsigned @UnknownVal long number, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        @Unsigned int part2 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        number = UnsignedValues.uDivide(number, 10000000L);
        @Unsigned int part1 = UnsignedValues.toUint(UnsignedValues.uRemainder(number, 10000000L));
        @Unsigned int part0 = UnsignedValues.toUint(UnsignedValues.uDivide(number, 10000000L));
        if (part0 != 0) {
            FixedDtoa.fillDigits32(part0, buf);
            FixedDtoa.fillDigits32FixedLength(part1, 7, buf);
            FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
        } else if (part1 != 0) {
            FixedDtoa.fillDigits32(part1, buf);
            FixedDtoa.fillDigits32FixedLength(part2, 7, buf);
        } else {
            FixedDtoa.fillDigits32(part2, buf);
        }
    }

    private static void fillFractionals(@Unsigned @UnknownVal long fractionals, @UnknownVal @Signed int exponent, @UnknownVal @Signed int fractionalCount, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        if (Assert.assertEnabled()) {
            Assert.assertThat(-128 <= exponent && exponent <= 0);
        }
        if (-exponent <= 64) {
            int digit;
            if (Assert.assertEnabled()) {
                Assert.assertThat(fractionals >>> 56 == 0L);
            }
            int point = -exponent;
            for (int i = 0; i < fractionalCount && fractionals != 0L; fractionals -= UnsignedValues.toUlong(digit) << point, ++i) {
                digit = UnsignedValues.toUint((fractionals *= 5L) >>> --point);
                buf.append(digit);
            }
            if (Assert.assertEnabled()) {
                Assert.assertThat(fractionals == 0L || point - 1 >= 0);
            }
            if (fractionals != 0L && (fractionals >>> point - 1 & 1L) == 1L) {
                buf.roundUp();
            }
        } else {
            if (Assert.assertEnabled()) {
                Assert.assertThat(64 < -exponent && -exponent <= 128);
            }
            UInt128 fractionals128 = new UInt128(fractionals, 0L);
            fractionals128 = fractionals128.shift(-exponent - 64);
            int point = 128;
            for (int i = 0; i < fractionalCount && !fractionals128.isZero(); ++i) {
                fractionals128 = fractionals128.times(5L);
                UInt128.QuotientRemainder qr = fractionals128.divModPowerOf2(--point);
                @Unsigned int digit = qr.quotient;
                fractionals128 = qr.remainder;
                buf.append(digit);
            }
            if (fractionals128.bitAt(point - 1) == 1) {
                buf.roundUp();
            }
        }
    }

    public static @UnknownVal @UnknownSignedness boolean fastFixedDtoa(@UnknownVal @Signed double v, @UnknownVal @Signed int fractionalCount, @UnknownVal @UnknownSignedness DecimalRepBuf buf) {
        @Unsigned long kMaxUInt32 = 0xFFFFFFFFL;
        @Unsigned long significand = new Ieee.Double(v).significand();
        int exponent = new Ieee.Double(v).exponent();
        if (exponent > 20) {
            return false;
        }
        if (fractionalCount > 20) {
            return false;
        }
        buf.clearBuf();
        if (exponent + 53 > 64) {
            long remainder;
            int quotient;
            @SignedPositive int positiveExponent = exponent;
            @Unsigned long kFive17 = 762939453125L;
            @Unsigned long divisor = 762939453125L;
            @SignedPositive int divisorPower = 17;
            @Unsigned long dividend = significand;
            if (exponent > divisorPower) {
                quotient = UnsignedValues.toUint(UnsignedValues.uDivide(dividend <<= (int)UnsignedValues.toUlongFromSigned(positiveExponent - divisorPower), divisor));
                remainder = UnsignedValues.uRemainder(dividend, divisor) << divisorPower;
            } else {
                quotient = UnsignedValues.toUint(UnsignedValues.uDivide(dividend, divisor <<= (int)UnsignedValues.toUlongFromSigned(divisorPower - positiveExponent)));
                remainder = UnsignedValues.uRemainder(dividend, divisor) << exponent;
            }
            FixedDtoa.fillDigits32(quotient, buf);
            FixedDtoa.fillDigits64FixedLength(remainder, buf);
            buf.setPointPosition(buf.length());
        } else if (exponent >= 0) {
            FixedDtoa.fillDigits64(significand <<= exponent, buf);
            buf.setPointPosition(buf.length());
        } else if (exponent > -53) {
            long integrals = significand >>> -exponent;
            long fractionals = significand - (integrals << -exponent);
            if (!UnsignedValues.isAssignableToUint(integrals)) {
                FixedDtoa.fillDigits64(integrals, buf);
            } else {
                FixedDtoa.fillDigits32(UnsignedValues.toUint(integrals), buf);
            }
            buf.setPointPosition(buf.length());
            FixedDtoa.fillFractionals(fractionals, exponent, fractionalCount, buf);
        } else if (exponent < -128) {
            if (Assert.assertEnabled()) {
                Assert.assertThat(fractionalCount <= 20);
            }
            buf.clearBuf();
            buf.setPointPosition(-fractionalCount);
        } else {
            buf.setPointPosition(0);
            FixedDtoa.fillFractionals(significand, exponent, fractionalCount, buf);
        }
        buf.trimZeros();
        if (buf.length() == 0) {
            buf.setPointPosition(-fractionalCount);
        }
        return true;
    }

    static class UInt128 {
        private static final @Unsigned @UnknownVal long MASK_32 = 0xFFFFFFFFL;
        private final @Unsigned @UnknownVal long high;
        private final @Unsigned @UnknownVal long low;

        public UInt128() {
            this.high = 0L;
            this.low = 0L;
        }

        public UInt128(@Unsigned @UnknownVal long high, @Unsigned @UnknownVal long low) {
            this.high = high;
            this.low = low;
        }

        @Unsigned @UnknownVal long rawHigh() {
            return this.high;
        }

        @Unsigned @UnknownVal long rawLow() {
            return this.low;
        }

        public @UnknownVal @UnknownSignedness UInt128 times(@Unsigned @UnknownVal long multiplicand) {
            long accumulator = (this.low & 0xFFFFFFFFL) * multiplicand;
            long part = accumulator & 0xFFFFFFFFL;
            accumulator >>>= 32;
            long newLowBits = ((accumulator += (this.low >>> 32) * multiplicand) << 32) + part;
            accumulator >>>= 32;
            part = (accumulator += (this.high & 0xFFFFFFFFL) * multiplicand) & 0xFFFFFFFFL;
            accumulator >>>= 32;
            long newHighBits = ((accumulator += (this.high >>> 32) * multiplicand) << 32) + part;
            if (Assert.assertEnabled()) {
                Assert.assertThat(accumulator >>> 32 == 0L);
            }
            return new UInt128(newHighBits, newLowBits);
        }

        public @UnknownVal @UnknownSignedness UInt128 shift(@UnknownVal @Signed int shift_amount) {
            long nLow;
            long nHigh;
            if (Assert.assertEnabled()) {
                Assert.assertThat(-64 <= shift_amount && shift_amount <= 64);
            }
            if (shift_amount == 0) {
                return this;
            }
            if (shift_amount == -64) {
                nHigh = this.low;
                nLow = 0L;
            } else if (shift_amount == 64) {
                nHigh = 0L;
                nLow = this.high;
            } else if (shift_amount <= 0) {
                nHigh = this.high << -shift_amount;
                nHigh += this.low >>> 64 + shift_amount;
                nLow = this.low << -shift_amount;
            } else {
                nLow = this.low >>> shift_amount;
                nLow += this.high << 64 - shift_amount;
                nHigh = this.high >>> shift_amount;
            }
            return new UInt128(nHigh, nLow);
        }

        public @UnknownVal @UnknownSignedness QuotientRemainder divModPowerOf2(@UnknownVal @Signed int power) {
            long remLow;
            long remHigh;
            int quotient;
            if (power >= 64) {
                quotient = UnsignedValues.toUint(this.high >>> power - 64);
                remHigh = this.high - ((long)quotient << power - 64);
                remLow = this.low;
            } else {
                long partLow = this.low >>> power;
                long partHigh = this.high << 64 - power;
                quotient = (int)(partLow + partHigh);
                remHigh = 0L;
                remLow = this.low - (partLow << power);
            }
            return new QuotientRemainder(quotient, new UInt128(remHigh, remLow));
        }

        public @UnknownVal @UnknownSignedness boolean isZero() {
            return this.high == 0L && this.low == 0L;
        }

        public @UnknownVal @Signed int bitAt(@UnknownVal @Signed int position) {
            if (position >= 64) {
                return (int)(this.high >>> position - 64) & 1;
            }
            return (int)(this.low >>> position) & 1;
        }

        public static class QuotientRemainder {
            public final @Unsigned @UnknownVal int quotient;
            public final @UnknownVal @UnknownSignedness UInt128 remainder;

            public QuotientRemainder(@Unsigned @UnknownVal int quotient, @UnknownVal @UnknownSignedness UInt128 remainder) {
                this.quotient = quotient;
                this.remainder = remainder;
            }
        }
    }
}

